/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.init.compat.jei;

import committee.nova.mods.avaritia.client.screen.CompressorScreen;
import committee.nova.mods.avaritia.client.screen.ExtremeCraftingScreen;
import committee.nova.mods.avaritia.common.item.singularity.Singularity;
import committee.nova.mods.avaritia.common.menu.ExtremeCraftingMenu;
import committee.nova.mods.avaritia.init.compat.jei.category.CompressorCategory;
import committee.nova.mods.avaritia.init.compat.jei.category.ExtremeCraftingTableCategory;
import committee.nova.mods.avaritia.init.registry.ModBlocks;
import committee.nova.mods.avaritia.init.registry.ModItems;
import committee.nova.mods.avaritia.init.registry.ModMenus;
import committee.nova.mods.avaritia.init.registry.ModRecipeTypes;
import committee.nova.mods.avaritia.util.SingularityUtils;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

@JeiPlugin
public class JeiCompat
implements IModPlugin {
    public static final ResourceLocation UID = new ResourceLocation("avaritia", "jei_plugin");
    public static final ResourceLocation ICONS = new ResourceLocation("avaritia", "textures/gui/jei/icons.png");

    @NotNull
    public ResourceLocation getPluginUid() {
        return UID;
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IGuiHelper helper = registration.getJeiHelpers().getGuiHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{new CompressorCategory(helper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new ExtremeCraftingTableCategory(helper)});
    }

    public void registerRecipes(@NotNull IRecipeRegistration registration) {
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        if (world != null) {
            RecipeManager manager = world.m_7465_();
            registration.addRecipes(CompressorCategory.RECIPE_TYPE, manager.m_44013_((net.minecraft.world.item.crafting.RecipeType)ModRecipeTypes.COMPRESSOR_RECIPE.get()));
            registration.addRecipes(ExtremeCraftingTableCategory.RECIPE_TYPE, manager.m_44013_((net.minecraft.world.item.crafting.RecipeType)ModRecipeTypes.EXTREME_CRAFT_RECIPE.get()));
            registration.addIngredientInfo((Object)new ItemStack((ItemLike)((Block)ModBlocks.neutron_collector.get()).m_5456_()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.m_237115_((String)"jei.tooltip.avaritia.neutron_collector")});
            registration.addIngredientInfo((Object)new ItemStack((ItemLike)ModItems.neutron_pile.get()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.m_237115_((String)"jei.tooltip.avaritia.neutron_pile")});
        }
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.neutron_compressor.get()), new RecipeType[]{CompressorCategory.RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.extreme_crafting_table.get()), new RecipeType[]{ExtremeCraftingTableCategory.RECIPE_TYPE});
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler(ExtremeCraftingMenu.class, (MenuType)ModMenus.extreme_crafting_table.get(), ExtremeCraftingTableCategory.RECIPE_TYPE, 1, 81, 82, 36);
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addRecipeClickArea(CompressorScreen.class, 89, 35, 21, 16, new RecipeType[]{CompressorCategory.RECIPE_TYPE});
        registration.addRecipeClickArea(ExtremeCraftingScreen.class, 174, 90, 21, 14, new RecipeType[]{ExtremeCraftingTableCategory.RECIPE_TYPE});
    }

    public void registerItemSubtypes(@NotNull ISubtypeRegistration registration) {
        ModItems.singularity.ifPresent(item -> registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, item, (stack, context) -> {
            Singularity singularity = SingularityUtils.getSingularity(stack);
            return singularity != null ? singularity.getId().toString() : "";
        }));
    }
}

